--------------------------------------------------------------------
--            SymCACP Script Module 1       
-- Symmetrical CA Control Panel   symCACPscript-1
-- file module for Staining cells with cell counts listed
--------------------------------------------------------------------
--  P. Rendell   23/03/2023
--------------------------------------------------------------------

--==============================================================================
------------------------------------------------------------

local scriptType = "script-Stain"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local logDiverted = false
m.colonList = {['CNTS'] = {'d',""}}
m.equalList = {['RUN'] = {'d',""}}
------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
--==============================================================================

local function threeState2two(patt)
   local newPatt = {}
   
   if #patt%2 == 1 then     
      for i = 1, #patt, 3 do
         if #patt >= i+2 then
            if patt[i+2] == 1 then
               newPatt[#newPatt+1] = patt[i]
               newPatt[#newPatt+1] = patt[i+1]
            end
         end
      end
   else
      newPatt = patt
   end   
   return (newPatt)
end
--==============================================================================

local function twoState2tthree(patt1,patt2)
   local newPatt = {}
   
   if #patt1%2 == 1 then  
      for i = 1, #patt1, 3 do
         if #patt1 >= i+2 then
            if patt1[i+2] == 1 then
               newPatt[#newPatt+1] = patt1[i]
               newPatt[#newPatt+1] = patt1[i+1]
               newPatt[#newPatt+1] = 1
            end
         end
      end
   else
      for i = 1, #patt1, 2 do
         if #patt1 >= i+1 then
            newPatt[#newPatt+1] = patt1[i]
            newPatt[#newPatt+1] = patt1[i+1]
            newPatt[#newPatt+1] = 1
         end
      end
   end
   
   if #patt2%2 == 1 then  
      for i = 1, #patt2, 3 do
         if #patt2 >= i+2 then
            if patt2[i+2] == 1 then
               newPatt[#newPatt+1] = patt2[i]
               newPatt[#newPatt+1] = patt2[i+1]
               newPatt[#newPatt+1] = 2
            end
         end
      end
   else
      for i = 1, #patt2, 2 do
         if #patt2 >= i+1 then
            newPatt[#newPatt+1] = patt2[i]
            newPatt[#newPatt+1] = patt2[i+1]
            newPatt[#newPatt+1] = 2
         end
      end
   end

   if #newPatt%2 == 0 then  
      newPatt[#newPatt+1] = 0
   end
   return (newPatt)
end
--==================================================================

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

local function vPlus(v,vmax)
   if (v < vmax) then
      v = v + 1
   else
      v = 1
   end
   return(v)
end
------------------------------------------------------------

local function vMinus(v,vmax)
   if (v > 1) then
      v = v - 1
   else
      v = vmax
   end
   return(v)
end
------------------------------------------------------------

-- looking for 2 peakes in the counts
local function findVericals(uCnts, wd, ht)
   local cell = {0,0,0,0,0,0,0,0}
   local cellWd = ht//7
   for i = 1, wd do
      for j = 1, ht do
         if (uCnts[i][j] == 1) then
            local k = i//cellWd + 1
            cell[k] = cell[k] + 1
         end
      end
   end
   local str = ""
   local maxV = 0
   local maxI = 0
   for i = 1,8 do
      str = str.." "..cell[i]
      if (cell[i] > maxV) then
         maxV = cell[i]
         maxI = i
      end
   end
   
   -- create step shape left to right
   local i = maxI
   local v = maxV
   for k = 1,8 do
      if (cell[i] < v) then
         v = cell[i]
         cell[i] = 0
      else
         v = cell[i]
      end
      i = (i%8)+1
   end

   -- create step shape right to left
   i = maxI
   v = maxV
   for k = 1,8 do
      if (cell[i] < v) then
         v = cell[i]
         cell[i] = 0
      else
         v = cell[i]
      end
      i = i-1
      if (i == 0) then i = 8 end
   end
   
   -- narrow step to one cell create list of steps
   local steps = {}
   local j
   for k = 1,8 do
      if (cell[i] > 0 ) then steps[#steps+1] = i end
      j = (i%8)+1
      if (cell[i] == cell[j]) then
         cell[j] = 0
      end
      i = j
   end
   local numSteps = #steps
   while (numSteps > 2) do
      local minStep = maxV
      j = maxI
      for i = 1,8 do
         if (cell[i] > 0 ) then
            minStep = math.min(minStep, cell[i]
         end

   end

   str = str.." : "
   for i = 1,8 do
      str = str.." "..cell[i]
   end

   g.note(str)
end
------------------------------------------------------------

function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  
   ---------------------------------------------------------
   local currindex = g.getlayer()
   local CntLayName = "CntLay"
   local CntLays = {}
   local wd = tonumber(g.getwidth())
   local ht = tonumber(g.getheight())
   local x0 = wd//2 + 1
   local y0 = ht//2 + 1
   local oldLay
   local gen = g.getgen()
   
   local uniPatt = threeState2two(g.getcells(g.getrect()))
   while ( g.numlayers() > currindex+1 ) do
      g.setlayer(g.numlayers()-1)
      g.dellayer()
   end
   g.setlayer(g.numlayers()-1)
   for i = 1,4 do
     CntLays[i] = g.addlayer()
     g.setname(CntLayName..i)
   end
   
   local uni = {};
   local uniL = {};
   uniL[1] = {}; uniL[2] = {}; uniL[3] = {}; uniL[4] = {}
   for i = 1,wd do
      uni[i] = {}; uniL[1][i] = {}; uniL[2][i] = {}; uniL[3][i] = {}; uniL[4][i] = {}
      for j = 1,ht do
         uni[i][j] = 0;
         uniL[1][i][j] = 0;
         uniL[2][i][j] = 0;  uniL[3][i][j] = 0;  uniL[4][i][j] = 0; 
      end
   end
   
   for i = 1, #uniPatt, 2 do
      uni[x0 + uniPatt[i]][y0 + uniPatt[i+1]] = 1
   end

   for i = 1,wd do
      for j = 1,ht do
         local cnt = uni[vMinus(i,wd)][vMinus(j,ht)] + uni[i][vMinus(j,ht)] + uni[vPlus(i,ht)][vMinus(j,ht)]
                   + uni[vMinus(i,wd)][j]                                   + uni[vPlus(i,ht)][j]
                   + uni[vMinus(i,wd)][vPlus(j,ht)]  + uni[i][vPlus(j,ht)]  + uni[vPlus(i,ht)][vPlus(j,ht)]
         if (cnt > 4) then cnt = 8 - cnt end
         if (cnt > 0) then
            uniL[cnt][i][j] = 1
         end
         for k = 1, cnt do
            g.setlayer(CntLays[k])
            g.setcell(i - x0, j - y0, 1)
         end
      end
   end
   g.setlayer(currindex)
   findVericals(uniL[1],wd,ht)
   findVericals(uniL[2],wd,ht)
   findVericals(uniL[3],wd,ht)
   findVericals(uniL[4],wd,ht)
end   
return m
------------------------------------------------------------
------------------------------------------ eof -----------------------------------------
